require( "scripts/style.lua" );


local yes="yes" ;
local yesname="yes" ;
local no="no" ;	
local noname="no" ;	
local name="yesnobox";
	
if (gDialogTable.yeslabel) then
	yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
	no = gDialogTable.nolabel ;
end
if (gDialogTable.yesname) then
	yesname = gDialogTable.yesname;
end
if (gDialogTable.noname) then
	noname = gDialogTable.noname;
end

if (gDialogTable.name) then
	name = gDialogTable.name;
end

local noslide = gDialogTable.noslide;
local yescmd = gDialogTable.yes;
local nocmd = gDialogTable.no;

YESNOSPEC =
{
	image = "backgrounds/dialog",
	mask = exists("backgrounds/dialog.mask.png"),
	x = kCenter,
	y = kCenter,

	SetStyle(DialogTitleText),
    Text
	{
		name = "yesnotitle",
		label = gDialogTable.title,
		
		w = 250,
		x = kCenter,
		y = 0,
	};
	
	SetStyle(DialogBodyText),
	Text
	{
		name = "yesnobody",
		label = gDialogTable.body,
		w = 250,
		x = kCenter,
		y = 70,
		--flags = kVAlignCenter + kHAlignCenter,
	};

    SetStyle(ThinButtonStyle),
    
    Button
    {
		command = function()
			if (yescmd) then 
				yescmd() ; 
			end
			if noslide then
--				CloseWindow();
			else
				StartClose();
			end
		end;
		
        -- close = true,
        
        flags = 5,
        label = yes,
        name = yesname,
        x = kCenter,
        y = -65,
    },
    
    Button
    {
		command= function() 
			if (nocmd) then
				nocmd() ; 
			end
--			if noslide then
--				CloseWindow();
--			else
				StartClose();
--			end
		end;
        flags = 5,
        label = no,
        name = noname,
        x = kCenter,
        y = -40,
    },
};

MakeDialog
{
	name=name, -- Remember, this is like saying table['name']=name, so it works.
	tTransitionWindow
	{
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		Bitmap(YESNOSPEC)
	}
} -- MakeDialog
